/***************************************************************************
 * SPDX-FileCopyrightText: 2023 {{cookiecutter.author}} {{cookiecutter.email}}
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * {{cookiecutter.description}}
 *
 * @author {{cookiecutter.email}}
 */
#include "skg{{cookiecutter.__plugin_slug}}plugin.h"

#include <kactioncollection.h>
#include <kstandardaction.h>
#include <kaboutdata.h>
#include <kpluginfactory.h>

#include "skg{{cookiecutter.__plugin_slug}}pluginwidget.h"
#include "skg{{cookiecutter.__plugin_slug}}_settings.h"
#include "skgtraces.h"

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKG{{cookiecutter.__plugin_slug}}PluginFactory, registerPlugin<SKG{{cookiecutter.__plugin_slug}}Plugin>();)

SKG{{cookiecutter.__plugin_slug}}Plugin::SKG{{cookiecutter.__plugin_slug}}Plugin(QWidget* iWidget, QObject* iParent, const QVariantList& /*iArg*/) :
    SKGInterfacePlugin(iParent), m_currentDocument(nullptr)
{
    Q_UNUSED(iWidget)
    SKGTRACEINFUNC(10)
}

SKG{{cookiecutter.__plugin_slug}}Plugin::~SKG{{cookiecutter.__plugin_slug}}Plugin()
{
    SKGTRACEINFUNC(10)
    m_currentDocument = nullptr;
}

bool SKG{{cookiecutter.__plugin_slug}}Plugin::setupActions(SKGDocument* iDocument)
{
    SKGTRACEINFUNC(10)

    m_currentDocument = iDocument;

    setComponentName("skrooge_{{cookiecutter.__plugin_slug}}", title());
    setXMLFile("skrooge_{{cookiecutter.__plugin_slug}}.rc");

    // Create yours actions here
    return true;
}

void SKG{{cookiecutter.__plugin_slug}}Plugin::refresh()
{
    SKGTRACEINFUNC(10)
}

SKGTabPage* SKG{{cookiecutter.__plugin_slug}}Plugin::getWidget()
{
    SKGTRACEINFUNC(10)
    return new SKG{{cookiecutter.__plugin_slug}}PluginWidget(SKGMainPanel::getMainPanel(), m_currentDocument);
}

QWidget* SKG{{cookiecutter.__plugin_slug}}Plugin::getPreferenceWidget()
{
    SKGTRACEINFUNC(10)
    auto w = new QWidget();
    ui.setupUi(w);

    return w;
}

KConfigSkeleton* SKG{{cookiecutter.__plugin_slug}}Plugin::getPreferenceSkeleton()
{
    return skg{{cookiecutter.__plugin_slug}}_settings::self();
}

SKGError SKG{{cookiecutter.__plugin_slug}}Plugin::savePreferences() const
{
    return SKGError();
}

QString SKG{{cookiecutter.__plugin_slug}}Plugin::title() const
{
    return i18nc("The title", "{{cookiecutter.plugin_name}}");  // TODO(You) MUST BE CHANGED
}

QString SKG{{cookiecutter.__plugin_slug}}Plugin::icon() const
{
    return "dialog-information";  // TODO(You) MUST BE CHANGED
}

QString SKG{{cookiecutter.__plugin_slug}}Plugin::toolTip() const
{
    return i18nc("The tool tip", "{{cookiecutter.plugin_name}}");  // TODO(You) MUST BE CHANGED
}

int SKG{{cookiecutter.__plugin_slug}}Plugin::getOrder() const
{
    return 999;
}

QStringList SKG{{cookiecutter.__plugin_slug}}Plugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>... {{cookiecutter.__plugin_slug}} is the best plugin of the world</p>"));  // TODO(You) MUST BE CHANGED
    return output;
}

bool SKG{{cookiecutter.__plugin_slug}}Plugin::isInPagesChooser() const
{
    return true;
}

#include <skg{{cookiecutter.__plugin_slug}}plugin.moc>


